package com.ejie.ab18a.control;

import com.ejie.ab18a.service.Ab18aTicketPeticionService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.ab18a.model.Ab18aTicketPeticion;

/**
 * Ab18a07s00Controller generated by XXXX, 03-feb-2017 12:02:33.
 * 
 * @author XXXX
 */

@Controller
@RequestMapping(value = "/ab18a07s00")
public class Ab18a07s00Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Ab18a07s00Controller.class);

	@Autowired
	private Ab18aTicketPeticionService ticketPeticionService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param t07IdTicket
	 *            Long
	 * @return Ab18a07s00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{t07IdTicket}", method = RequestMethod.GET)
	public @ResponseBody
	Ab18aTicketPeticion get(@PathVariable Integer t07IdTicket) {
		Ab18aTicketPeticion ab18a07s00 = new Ab18aTicketPeticion();
		ab18a07s00.setT07IdTicket(t07IdTicket);
		ab18a07s00 = this.ticketPeticionService.find(ab18a07s00);
		Ab18a07s00Controller.logger
				.info("[GET - findBy_PK] : Obtener Ab18a07s00 por PK");
		return ab18a07s00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Ab18a07s00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Ab18aTicketPeticion> getAll(
			@ModelAttribute Ab18aTicketPeticion filterAb18a07s00) {
		Ab18a07s00Controller.logger
				.info("[GET - find_ALL] : Obtener Ab18a07s00 por filtro");
		return this.ticketPeticionService.findAll(filterAb18a07s00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00 Bean que contiene la informacion a modificar.
	 * @return Ab18a07s00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Ab18aTicketPeticion edit(@RequestBody Ab18aTicketPeticion ab18a07s00) {
		Ab18aTicketPeticion ab18a07s00Aux = this.ticketPeticionService
				.update(ab18a07s00);
		Ab18a07s00Controller.logger
				.info("[PUT] : Ab18a07s00 actualizado correctamente");
		return ab18a07s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param ticketPeticion
	 *            Ab18aTicketPeticion Bean que contiene la informacion con la
	 *            que se va a crear el nuevo registro.
	 * @return Ab18aTicketPeticion Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ab18aTicketPeticion add(@RequestBody Ab18aTicketPeticion ticketPeticion) {
		Ab18aTicketPeticion ticketPeticionAux = new Ab18aTicketPeticion();
		try {
			ticketPeticionAux = this.ticketPeticionService.add(ticketPeticion);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Ab18a07s00Controller.logger
				.info("[POST] : Ab18a07s00 insertado correctamente");
		return ticketPeticionAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param t07IdTicket
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Ab18a07s00 Bean eliminado.
	 */
	@RequestMapping(value = "/{t07IdTicket}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Ab18aTicketPeticion remove(@PathVariable Integer t07IdTicket) {
		Ab18aTicketPeticion ab18a07s00 = new Ab18aTicketPeticion();
		ab18a07s00.setT07IdTicket(t07IdTicket);
		this.ticketPeticionService.remove(ab18a07s00);
		Ab18a07s00Controller.logger
				.info("[DELETE] : Ab18a07s00 borrado correctamente");
		return ab18a07s00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Ab18a07s00Controller.logger.info("[GET - View] : ab18a07s00");
		return "ab18a07s00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Ab18a07s00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Ab18aTicketPeticion> filter(
			@RequestJsonBody(param = "filter") Ab18aTicketPeticion filterAb18a07s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a07s00Controller.logger
				.info("[POST - filter] : Obtener Ab18a07s00s");
		return this.ticketPeticionService.filter(filterAb18a07s00,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAb18a07s00
	 *            Ab18a07s00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Ab18a07s00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Ab18aTicketPeticion>> search(
			@RequestJsonBody(param = "filter") Ab18aTicketPeticion filterAb18a07s00,
			@RequestJsonBody(param = "search") Ab18aTicketPeticion searchAb18a07s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a07s00Controller.logger
				.info("[POST - search] : Buscar Ab18a07s00s");
		return this.ticketPeticionService.search(filterAb18a07s00,
				searchAb18a07s00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Ab18aTicketPeticion filterAb18a07s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a07s00Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Ab18a07s00s");
		this.ticketPeticionService.removeMultiple(filterAb18a07s00,
				jqGridRequestDto, false);
		Ab18a07s00Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a07s00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Ab18aTicketPeticion>> jerarquia(
			@RequestJsonBody(param = "filter") Ab18aTicketPeticion filterAb18a07s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a07s00Controller.logger
				.info("[POST - jerarquia] : Obtener Ab18a07s00s jerarquia");
		return this.ticketPeticionService.jerarquia(filterAb18a07s00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a07s00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Ab18aTicketPeticion>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Ab18aTicketPeticion filterAb18a07s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a07s00Controller.logger
				.info("[POST - jerarquia] : Obtener Ab18a07s00s jerarquia - Hijos");
		return this.ticketPeticionService.jerarquiaChildren(filterAb18a07s00,
				jqGridRequestDto);
	}

}
